# Hero Slider Image Upload - Complete Guide

## Overview
The hero slider now supports image uploads for each slide. You can upload custom background images with drag-and-drop support and responsive design for all device sizes.

## Features Implemented

### 1. **Image Upload Form**
- Clean, responsive upload interface in the hero slider modal
- Drag-and-drop support for easy file selection
- Click to upload option
- Image preview with remove button
- File type validation (JPG, PNG, GIF, WebP)
- File size validation (Max 5MB)

### 2. **Responsive Design**
- Desktop (>768px): Full-featured upload with large preview
- Tablet (768px-480px): Optimized spacing and sizing
- Mobile (<480px): Compact layout with full-width preview

### 3. **Backend File Handling**
- Automatic directory creation: `assets/uploads/hero-slider/`
- Unique filename generation using timestamp + unique ID
- Automatic old image deletion when updating
- Image cleanup on slide deletion
- File validation on server side

### 4. **Database Integration**
- New field `slide_image` stores uploaded filename
- Fallback to default image if no upload
- Works with all CRUD operations (Add, Edit, Delete)

## How to Use

### Adding a New Slide with Image

1. **Navigate to Admin Dashboard**
   - Login to admin panel
   - Go to "Hero Slider" section
   - Click "Add Slide" button

2. **Fill in the Form**
   - Enter slide title and description
   - Configure badge, buttons, and statistics
   - **Scroll to "Slide Image" section**

3. **Upload Image**
   - **Option A:** Click on the dashed border area
   - **Option B:** Drag and drop an image file
   - Image preview will appear below

4. **Save the Slide**
   - Click "Save Slide" button
   - Image will be uploaded and associated with the slide

### Editing an Existing Slide

1. **Open Edit Modal**
   - In the slides list, click the edit icon for a slide
   - Existing image will display in the preview

2. **Change Image (Optional)**
   - Click the image area to select a new image
   - Or drag and drop a new image
   - Remove current image by clicking "Remove Image" button

3. **Save Changes**
   - Click "Save Slide" button
   - Old image is automatically deleted from server

### Deleting a Slide

- Click the delete button for a slide
- Image associated with the slide is automatically deleted
- Confirms deletion action first

## Technical Details

### File Structure
```
assets/
├── uploads/
│   └── hero-slider/          # Image storage directory
│       ├── slider_1234567_abc123.jpg
│       ├── slider_1234568_def456.png
│       └── ...
```

### Image Validation

**Client-side (JavaScript):**
- File type check: image/jpeg, image/png, image/gif, image/webp
- File size check: Maximum 5MB
- Visual feedback during upload

**Server-side (PHP):**
- File type re-validation
- File size re-validation
- Error handling with user-friendly messages

### Filename Format
- Pattern: `slider_{timestamp}_{uniqueId}.{extension}`
- Example: `slider_1704067200_5f8a9c2b.jpg`
- Prevents filename conflicts and ensures uniqueness

### Database Field
```sql
ALTER TABLE hero_slider ADD COLUMN slide_image VARCHAR(255) DEFAULT NULL;
```

## API Endpoints

### Upload with Add Slide
```
POST /hero_slider_handler.php
Content-Type: multipart/form-data

Parameters:
- action: "add"
- title: string (required)
- description: string (required)
- badge: string (optional)
- badge_icon: string (optional)
- ... other fields ...
- slide_image: file (optional)
```

### Upload with Edit Slide
```
POST /hero_slider_handler.php
Content-Type: multipart/form-data

Parameters:
- action: "edit"
- id: integer (required)
- title: string (required)
- description: string (required)
- ... other fields ...
- slide_image: file (optional)
```

## File Locations

### Important Directories
| Directory | Purpose |
|-----------|---------|
| `assets/uploads/hero-slider/` | Image storage |
| `assets/uploads/.htaccess` | Security configuration |

### Modified Files
| File | Changes |
|------|---------|
| `admin-dashboard.php` | Added image upload form, CSS, and JS handlers |
| `hero_slider_handler.php` | Added image handling functions, file operations |
| `index.php` | Updated to display uploaded images |

## Troubleshooting

### Images Not Uploading
**Problem:** Upload fails with error message

**Solutions:**
1. Check file type - only JPG, PNG, GIF, WebP allowed
2. Check file size - must be less than 5MB
3. Verify `assets/uploads/hero-slider/` directory exists
4. Check folder permissions (should be writable)

### Old Images Not Being Deleted
**Problem:** Multiple image files accumulate

**Solutions:**
1. Manually delete unused images from `assets/uploads/hero-slider/`
2. Run cleanup: `http://localhost/Cleaning Service/cleanup_hero_images.php` (optional utility)

### Image Not Displaying on Homepage
**Problem:** Image uploads work but don't show on hero slider

**Solutions:**
1. Check if slide is marked as "Active"
2. Verify image file exists in `assets/uploads/hero-slider/`
3. Check browser console for 404 errors
4. Clear browser cache and refresh page

### Upload Button Not Working
**Problem:** Image upload area not responding

**Solutions:**
1. Check browser console for JavaScript errors
2. Verify admin authentication
3. Try different browser
4. Clear browser cache

## Security Features

### Implemented Protections
- File type validation (extension + MIME type)
- File size limitation (5MB max)
- Unique filename generation to prevent overwrites
- Directory-level access restriction via `.htaccess`
- PHP script execution prevention in uploads folder
- Session authentication check before upload

### Best Practices
- Only trusted admins can upload
- Images are validated both client and server side
- Old files are properly cleaned up
- No executable files can be uploaded

## Mobile Responsiveness

### Desktop View (>768px)
- Large upload zone (20px padding)
- Full-size icon (40px)
- Large text instructions
- Full image preview (max 250px height)

### Tablet View (768px-480px)
- Medium padding (15px)
- Medium icon (30px)
- Standard text size
- Medium preview (max 200px height)

### Mobile View (<480px)
- Compact padding (10px)
- Small icon (25px)
- Small text (12px)
- Compact preview (max 150px height)
- Full-width buttons and forms

## Performance Optimization

### Image Handling
- Lazy loading recommended for hero slider
- Consider image compression before upload
- WebP format recommended for smaller file sizes
- CDN integration possible for faster delivery

### Database
- Indexed `id` field for fast lookups
- `is_active` and `slide_order` indexed for sorting
- `slide_image` field allows NULL for flexibility

## Future Enhancements

Possible improvements for future versions:
1. Image cropping tool in modal
2. Automatic image compression
3. Multiple image upload at once
4. Image optimization/resizing
5. CloudFile storage integration
6. Image gallery preview
7. Drag-to-reorder images

## Support

For issues or questions:
1. Check the troubleshooting section above
2. Review browser console for errors
3. Check server logs for upload errors
4. Verify database has `slide_image` field

## Version Information

- **Feature Added:** Hero Slider Image Upload v1.0
- **Date:** 2024
- **Compatibility:** PHP 7.0+, MySQL 5.7+
- **Browser Support:** All modern browsers (Chrome, Firefox, Safari, Edge)

## Quick Reference

| Action | Location |
|--------|----------|
| Upload Image | Admin Dashboard → Hero Slider Tab → Add/Edit Modal |
| View Images | `assets/uploads/hero-slider/` |
| Edit Backend | `hero_slider_handler.php` (lines with `handleImageUpload()`) |
| Edit Frontend | `admin-dashboard.php` (lines with `image-upload-section`) |
| View on Site | Homepage hero slider section |

---

**Remember:** Always backup your database and image files before making bulk changes!
